# AutoAirItem 自动垃圾桶插件

- 作者: 羽学
- 出处: [自动垃圾桶](https://github.com/1242509682/AutoAirItem)
- Tshock版自动垃圾桶，帮助玩家清理自身垃圾的小插件
- 由玩家使用指令独立运行的插件，无需服主写配置，
- 它会自动根据玩家加入服务器自动创建配置结构。
- 通过玩家指令交互的一款全自动插件。


## 指令

| 语法                |        别名         |        权限         |         说明          |
|-------------------|:-----------------:|:-----------------:|:-------------------:|
| /air              |        /垃圾        |    AutoAir.use    |        指令菜单         |
| /air on           |      /垃圾 on       |    AutoAir.use    |    开启或关闭自身的垃圾桶功能    |
| /air list         |     /垃圾 list      |    AutoAir.use    |     列出自己的垃圾桶物品名     |
| /air clear        |     /垃圾 clear     |    AutoAir.use    |      清空自己的垃圾桶表      |
| /air yes          |      /垃圾 yes      |    AutoAir.use    |     手持物品加入垃圾桶表      |
| /air auto         |     /垃圾 auto      |    AutoAir.use    | 将物品放入垃圾桶位格时自动添加垃圾桶表 |
| /air mess         |     /垃圾 mess      |    AutoAir.use    |      开启或关闭清理消息      |
| /air ck 数量        |     /垃圾 ck 数量     |    AutoAir.use    |    筛选出物品超过此数量的玩家    |
| /air add 或 del id | /垃圾 add 或 del 物品名 |    AutoAir.use    |    添加或移出自己的垃圾桶物品    |
| /airreset         |      /重置垃圾桶       |   AutoAir.admin   |   清空玩家数据表（重置服务器用）   |
| /reload           |         无         | tshock.cfg.reload |       重载配置文件        |

## 配置
> 配置文件位置：tshock/自动垃圾桶.json
```json5
{
  "插件指令权限": "指令菜单：/air 或 /垃圾，权限名【AutoAir.use】，给玩家权限：/group addperm default AutoAir.use",
  "插件开关": true,
  "重启服务器不删数据": true,
  "排除垃圾表": [
    71,
    72,
    73,
    74
  ]
}
```

## 更新日志
```
v1.2.5
Database改utf-8
v1.2.3
将数据库表移到tshock.sqlite内部

v1.2.2
清理无用代码
修复已经在垃圾桶表里的物品，再次放入垃圾桶时不会主动清除的BUG
加入了移除物品时的物品数量反馈播报

v1.2.1
加入了【排除垃圾表】配置项
修复首次移除的物品没有返还数量的BUG
修复钱币也会被视为垃圾进行移除的BUG
修复/air ck查不到刚刚移除垃圾数量的BUG
补充首次放入垃圾桶的物品也会移除,并记录数量的逻辑
修复PE在使用/air del返还物品时,存在2句提示语的BUG

v1.2.0
给自动垃圾桶加入了数据库存储逻辑
避免每次重启服务器都会清空玩家垃圾桶用
请注意重置服务器时使用指令清空数据：/airreset

v1.1.7
修复PE使用：/air del 会返还双倍物品的BUG

v1.1.6
加入了/air ck 数量指令
筛选出物品超过此数量的玩家
修复返还物品超出物品叠堆上限的BUG

v1.1.5
把移除逻辑改为玩家移动触发（优化性能）
移除/air sd 修改清理速度指令
加入了/air del 的返还物品逻辑

v1.1.4
移除了自动清理玩家数据的逻辑与其相关配置项
将/air reset指令改为:
单独的/airreset指令方便跳出循环重置服务器

v1.1.3
美化了指令菜单
加入/air sd 修改垃圾清理速度指令
加入/air reset 清空所有玩家数据指令（用来重置服务器）
/air mess指令可控制隐藏：加入垃圾桶的物品提示

v1.1.2
修复玩家退出服务器时的空引用
将清理数据功能移到加入服务器事件中

v1.1.1
修复英文翻译（开源仓版）

v1.1.0
将数据表内容从Config移到插件内部的MyData类里，
不再以来对配置文件的频繁写入，避免玩家太多时把Config写爆。
第一次进服自动开启垃圾桶功能，并在玩家把物品放到垃圾桶时会触发相关指令提示
加入了对玩家在线状态判断，避免人在服里玩了24小时导致无辜被清理数据。
加入了对清理哪些玩家数据时的离服播报


v1.0.2
加入了将手持物品加入垃圾桶指令：/air yes
未选中后才会清理，选中时哪怕输错了，也可以用/air del 物品名 移除
加入了开启关闭清理信息指令：/air mess
加入了监听玩家垃圾桶位格功能，当物品放入垃圾桶时自动添加到《垃圾桶表》处理

v1.0.1
移除了每次/air add 或 del时的插件启用状态提醒
加入【清理数据周期】逻辑：
玩家每次进出服都会更新【记录时间】，
玩家A离线时间与玩家B登录时间相差
超过【清理周期】所设定的时间，则自动清理该玩家A的数据
如果《清理数据周期》:设置超过9999999999小时，就相当于永远不清理数据了

v1.0.0
根据使用Mod《更好的体验》的想法，实现的一个Tshock版自动垃圾桶
清理垃圾速度单位为帧率，数值越小清理越快。
使用指令/air on开启插件
使用/air add 物品名 或 物品id 或 Alt+左键点选物品，自动将物品名写入到配置文件当中
根据玩家进服事件自动创建  "玩家数据表"，
"垃圾桶物品"存在物品且开启了"垃圾桶开关"时会主动触发清理逻辑
配备了"登录时间"用于给服主参考：是否需要自己手动移除该玩家的数据
```



## 反馈
- 优先发issued -> 共同维护的插件库：https://github.com/UnrealMultiple/TShockPlugin
- 次优先：TShock官方群：816771079
- 大概率看不到但是也可以：国内社区trhub.cn ，bbstr.net , tr.monika.love
