# TShockConfigMultiLang 创建一个本地化语言的config

- 作者: 肝帝熙恩，羽学
- 出处: 本仓库
- 创建一个本地化语言的config，通过更改他来更改config，也可以反过来操作，同步后会自动重载
- 有可能会和一些对tshock自己config进行操作的插件冲突，一般可以手动解决


## 指令
| 语法                         |        权限         |        说明        |
|----------------------------|:-----------------:|:----------------:|
| /configToNewconfig 或 /ctc  | tshock.cfg.reload | 原版配置文件同步给本地化配置文件 |
| /configToFromconfig 或 /cfc | tshock.cfg.reload | 本地化配置文件同步给原版配置文件 |

## 配置
> 配置文件位置：tshock/config.zh-CN.json
```json5
{
  "服务器密码": "",
  "服务器端口": 7777,
  "服务器人数上限": 8,
  "服务器人满预留位": 20,
  "服务器名称": "",
  "是否使用服务器名称": false,
  "服务器日志存放路径": "tshock/logs",
  "是否启用报Debug日志": false,
  "禁用登录后进入": false,
  "允许箱子中物品堆叠超出限制": false,
  "世界图格提供器": "default",
  "启用自动保存": true,
  "自动保存世界广播提示": true,
  "是否显示备份自动保存消息": true,
  "自动备份间隔": 10,
  "备份保留时间": 240,
  "崩溃时保存世界": true,
  "最后玩家退出时保存世界": true,
  "事件入侵乘数": 1,
  "默认刷怪生成上限": 5,
  "默认刷怪率": 600,
  "事件无限入侵": false,
  "PVP模式": "normal",
  "启用出生点保护": true,
  "出生点保护范围": 10,
  "启用放置物块范围检查": true,
  "启用强制硬核角色": false,
  "启用强制中核角色": false,
  "启用强制软核角色": false,
  "禁止建筑": false,
  "禁止困难模式": false,
  "禁止生成地牢守卫": false,
  "禁止血月小丑炸弹": false,
  "禁止雪人雪块弹幕": false,
  "禁止玩家死亡生成墓碑": true,
  "禁止机械骷髅王炸弹": false,
  "强制世界时间": "normal",
  "禁止PVP隐身药水": false,
  "未登录时禁止移动范围": 10,
  "保护区域箱子": false,
  "保护区域内宝石锁": true,
  "忽略检查玩家弹幕更新": false,
  "忽略检查玩家弹幕销毁": false,
  "允许玩家破坏易碎方块": false,
  "允许玩家保护区域释放冰块": false,
  "允许猩红蔓延": true,
  "允许腐化蔓延": true,
  "允许神圣蔓延": true,
  "雕像停止生成前200像素(12.5格)内该NPC数量": 3,
  "雕像停止生成前600格(37.5格)内该NPC数量": 6,
  "整个世界雕像停止生成前该NPC数量": 10,
  "阻止禁用物品生成或指令获取": false,
  "阻止玩家死后与世界互动": true,
  "阻止玩家放置无效特殊值方块": true,
  "强制圣诞节": false,
  "强制万圣节": false,
  "允许可使用禁用物品的组生成禁用物品": false,
  "玩家复活时间": 0,
  "玩家BOSS战复活时间": 0,
  "不显示召唤BOSS或事件入侵的玩家": true,
  "玩家血量上限": 500,
  "玩家蓝量上限": 200,
  "爆炸影响范围": 5,
  "给予物品直接插入玩家背包(需SSC)": false,
  "玩家注册后的用户组": "default",
  "玩家注册前的用户组": "guest",
  "进服传回离线时的位置": false,
  "尝试登录次数上限": 3,
  "踢出死亡后的中核玩家": false,
  "踢出死亡后的中核玩家信息": "Death results in a kick",
  "封禁死亡后的中核玩家": false,
  "封禁死亡后的中核玩家信息": "因为死亡而被封禁",
  "关闭默认封禁IP": false,
  "启用IP白名单": false,
  "不在白名单被踢出的信息": "你不在白名单中。",
  "服务器人满提示信息": "服务器已满",
  "服务器人满且没有保留位的提示信息": "服务器已满（包括预留空间）。",
  "踢出死亡后的硬核玩家": false,
  "踢出死亡后的硬核玩家信息": "因为死亡而被踢出",
  "封禁死亡后的硬核玩家": false,
  "封禁死亡后的硬核玩家信息": "因为死亡而被封禁",
  "踢出代理IP用户": true,
  "用户必须登录": false,
  "允许玩家登录账号与角色名不符": true,
  "允许玩家注册账号与角色名不符": false,
  "密码最少长度": 4,
  "使用的BCrypt工作因子": 7,
  "禁止UUID自动登录": false,
  "踢出不发送UUID到服务器的玩家": false,
  "1秒内刷油漆的格数上限": 15,
  "踢出1秒内刷油漆超出格数上限的玩家": false,
  "玩家最大伤害上限": 1175,
  "玩家最大弹幕伤害上限": 1175,
  "踢出超出伤害上限的玩家": false,
  "1秒内破坏方块的格数上限": 60,
  "踢出1秒内破坏方块超出格数上限的玩家": false,
  "1秒内放置方块的格数上限": 32,
  "踢出1秒内放置方块超出格数上限的玩家": false,
  "1秒内放置液体的格数上限": 50,
  "踢出1秒内放置液体超出格数上限的玩家": false,
  "弹幕数量是否包含水晶子弹": true,
  "1秒内释放弹幕的数量上限": 50,
  "踢出1秒内释放弹幕超出数量上限的玩家": false,
  "1秒内治疗其他玩家的数值上限": 50,
  "踢出1秒内治疗其他玩家超出数值上限的玩家": false,
  "不提示受保护区域无权建筑信息": false,
  "禁止修改的天顶剑": false,
  "禁用自定义死亡信息": true,
  "指令前缀": "/",
  "隐藏指令前缀": ".",
  "不将日志作为聊天信息发送给有日志权限的玩家": true,
  "不将每秒的更新检查写入日志": false,
  "超级管理员的聊天颜色": [
    255,
    255,
    255
  ],
  "超管的聊天前缀": "（超级管理员）",
  "超管的聊天后缀": "",
  "显示加入服务器的玩家IP地理位置": false,
  "向有日志权限的管理显示进入玩家的IP": false,
  "聊天格式": "{1}{2}{3}: {4}",
  "聊天栏内玩家名字": "{2}",
  "是否在玩家头顶显示聊天消息": false,
  "系统广播文字颜色": [
    127,
    255,
    212
  ],
  "数据库类型": "sqlite",
  "数据库路径": "tshock.sqlite",
  "Mysql连接的ip和端口": "localhost:3306",
  "Mysql的数据库名称": "",
  "Mysql的用户名": "",
  "Mysql的密码": "",
  "是否把日志存入数据库": false,
  "Sql日志连接失败指定次数后变回文本日志": 10,
  "开启 Rest API": false,
  "Rest的端口": 7878,
  "记录Rest连线": false,
  "开启对Rest的权限认证": false,
  "Rest最大请求次数": 5,
  "Rest允许连接请求加一间隔": 1,
  "Rest外部应用令牌字典": {}
}
```


## 更新日志

```
v1.0.3
用指令会先加载现在的配置，再同步
```

## 反馈
- 优先发issued -> 共同维护的插件库：https://github.com/UnrealMultiple/TShockPlugin
- 次优先：TShock官方群：816771079
- 大概率看不到但是也可以：国内社区trhub.cn ，bbstr.net , tr.monika.love
