<div align="center">
  
[![TShockPlugin](https://socialify.git.ci/UnrealMultiple/TShockPlugin/image?description=1&descriptionEditable=A%20TShock%20Chinese%20Plugin%20Collection%20Repository&forks=1&issues=1&language=1&logo=https%3A%2F%2Fgithub.com%2FUnrealMultiple%2FTShockPlugin%2Fblob%2Fmaster%2Ficon.png%3Fraw%3Dtrue&name=1&pattern=Circuit%20Board&pulls=1&stargazers=1&theme=Auto)](https://github.com/UnrealMultiple/TShockPlugin)  
[![GitHub Actions Workflow Status](https://img.shields.io/github/actions/workflow/status/UnrealMultiple/TShockPlugin/.github%2Fworkflows%2Fbuild.yml)](https://github.com/UnrealMultiple/TShockPlugin/actions)
[![GitHub contributors](https://img.shields.io/github/contributors/UnrealMultiple/TShockPlugin?style=flat)](https://github.com/UnrealMultiple/TShockPlugin/graphs/contributors)
[![NET6](https://img.shields.io/badge/Core-%20.NET_6-blue)](https://dotnet.microsoft.com/zh-cn/)
[![QQ](https://img.shields.io/badge/QQ-EB1923?logo=tencent-qq&logoColor=white)](https://qm.qq.com/cgi-bin/qm/qr?k=54tOesIU5g13yVBNFIuMBQ6AzjgE6f0m&jump_from=webapi&authKey=6jzafzJEqQGzq7b2mAHBw+Ws5uOdl83iIu7CvFmrfm/Xxbo2kNHKSNXJvDGYxhSW)
[![TShock](https://img.shields.io/badge/TShock5.2.0-2B579A.svg?&logo=TShock&logoColor=white)](https://github.com/Pryaxis/TShock)

[简体中文](README.md) | [English](README.en-US.md) | **&gt; Spanish/Español &lt;**

</div>

## Introduccion
- Este es un repositorio dedicado a recopilar e integrar complementos "TShock".
- Algunos de los complementos de la biblioteca se recopilan de Internet y se descompilan.
- Debido a la naturaleza especial del proyecto, puede causar infracción. Si hay alguna infracción, por favor contáctenos para resolverla.
- Continuaremos recopilando complementos de "TShock" de alta calidad, actualizándolos de manera oportuna y estando al día con la última versión de "TShock".
- Si desea unirse a nosotros, siga las "Notas del desarrollador" y envíe una "Solicitud de extracción" a este repositorio.


## Notas de usuario

- Tenga en cuenta que algunos complementos pueden requerir dependencias; consulte la lista a continuación para instalar las dependencias.
- Cada complemento tiene una nota de uso; haga clic en el hipervínculo en la lista a continuación para ver las instrucciones específicas.
- Se dice que a las personas a las que les gusta destacar repositorios, sus complementos no son fáciles de generar errores.

## Descargas

- Github Release: [Plugins.zip](https://github.com/UnrealMultiple/TShockPlugin/releases/download/V1.0.0.0/Plugins.zip)
- ApmApi Release: [Plugins.zip](http://api.terraria.ink:11434/plugin/get_all_plugins)

#### AutoPluginManager
    /apm l Lista todos los plugins
    /apm i <plugin name> Una vez - Instalar Plugin
    /apm u [plugin name] Ver si el plugin tiene actualizacion

## Notas de Desarrollador

> Estandarización de codigo

- Está prohibido el uso de variables chinas.
- No utilice funciones peligrosas.
- Evite el uso de subprocesos múltiples siempre que sea posible.
- No dejar puertas traseras en los complementos.
- Incluya un archivo README.md con cada proyecto de complemento.

## Comentarios

> Cualquier comentario, sugerencia o mejora en esta biblioteca de códigos se considerará contribución pública y podrá incluirse en esta biblioteca de códigos a menos que se indique explícitamente lo contrario.

- Si hay un error, proporcione la información relevante del sistema, la versión de TShock y el proceso de reproducción del error en la página "problema" de GitHub.

### Plugins Recolectados

> Haga clic en los hipervínculos para ver la descripción detallada del complemento

> [!NOTE]
> Es posible que la documentación del complemento en inglés no se actualice tan rápidamente como la documentación del complemento en chino.
> Intente consultar la documentación china siempre que sea posible.

<Details>
<Summary>Listado de Plugins</Summary>

| Nombre del plugin | Porcentaje de traducción | Descripcion del Plugin  | Dependencias |
| :-: | :-: | :-: | :-: |
| [AdditionalPylons](./src/AdditionalPylons/README.md) | 90.0% | Colocar más pilones | [LazyAPI](./src/LazyAPI/README.md) |
| [AIChatPlugin](./src/AIChatPlugin/README.md) | 0.0% | AI聊天插件 |  |
| [AnnouncementBoxPlus](./src/AnnouncementBoxPlus/README.md) | 0.0% | Mejora la funcionalidad de la caja de anuncios | [LazyAPI](./src/LazyAPI/README.md) |
| [AutoAirItem](./src/AutoAirItem/README.md) | 0.0% | Botes de basura automáticos | [LazyAPI](./src/LazyAPI/README.md) |
| [AutoBroadcast](./src/AutoBroadcast/README.md) | 0.0% | Transmisión automática | [LazyAPI](./src/LazyAPI/README.md) |
| [AutoClear](./src/AutoClear/README.md) | 0.0% | Limpieza automática inteligente | [LazyAPI](./src/LazyAPI/README.md) |
| [AutoFish](./src/AutoFish/README.md) | 0.0% | Pesca automática | [LazyAPI](./src/LazyAPI/README.md) |
| [AutoPluginManager](./src/AutoPluginManager/README.es-ES.md) | 69.1% | Actualice los complementos automáticamente con una sola tecla |  |
| [AutoReset](./src/AutoReset/README.md) | 0.0% | Reinicio completamente automático | [LazyAPI](./src/LazyAPI/README.md) |
| [AutoStoreItems](./src/AutoStoreItems/README.md) | 0.0% | Almacenamiento automático | [LazyAPI](./src/LazyAPI/README.md) |
| [AutoTeam](./src/AutoTeam/README.md) | 0.0% | Formación automática de equipos | [LazyAPI](./src/LazyAPI/README.md) |
| [Back](./src/Back/README.md) | 0.0% | Regresar al punto de muerte | [LazyAPI](./src/LazyAPI/README.md) |
| [BagPing](./src/BagPing/README.md) | 0.0% | Marcar las bolsas de tesoro en el mapa |  |
| [BanNpc](./src/BanNpc/README.md) | 0.0% | Previene la generación de monstruos | [LazyAPI](./src/LazyAPI/README.md) |
| [BedSet](./src/BedSet/README.md) | 0.0% | Establecer y registrar puntos de resurrección | [LazyAPI](./src/LazyAPI/README.md) |
| [BetterWhitelist](./src/BetterWhitelist/README.md) | 0.0% | Plugin de lista blanca | [LazyAPI](./src/LazyAPI/README.md) |
| [BridgeBuilder](./src/BridgeBuilder/README.md) | 0.0% | Construcción rápida de puentes | [LazyAPI](./src/LazyAPI/README.md) |
| [BuildMaster](./src/BuildMaster/README.md) | 0.0% | Modo Maestro Constructor para el Mini Juego Red Bean | [MiniGamesAPI](./src/MiniGamesAPI/README.md) |
| [CaiBot](./src/CaiBot/README.md) | 0.0% | Plugin adaptador CaiBot (Only support QQ) |  |
| [CaiBotLite](./src/CaiBotLite/README.md) | 0.0% | Plugin adaptador CaiBot (Only support QQ) |  |
| [CaiCustomEmojiCommand](./src/CaiCustomEmojiCommand/README.md) | 0.0% | Comando de emoji personalizado | [LazyAPI](./src/LazyAPI/README.md) |
| [CaiLib](./src/CaiLib/README.md) | 0.0% | Biblioteca de precarga de Cai | [SixLabors.ImageSharp]() |
| [CaiPacketDebug](./src/CaiPacketDebug/README.md) | 0.0% | Herramienta de depuración de paquetes Cai | [LazyAPI](./src/LazyAPI/README.md) [TrProtocol]() |
| [CaiRewardChest](./src/CaiRewardChest/README.md) | 0.0% | Convierte cofres generados naturalmente en cofres de recompensa que todos pueden reclamar una vez | [linq2db]() [LazyAPI](./src/LazyAPI/README.md) |
| [CGive](./src/CGive/README.md) | 0.0% | Comandos fuera de línea |  |
| [Challenger](./src/Challenger/README.md) | 100.0% | Modo Challenger |  |
| [Chameleon](./src/Chameleon/README.md) | 0.0% | Inicia sesión antes de entrar al servidor | [LazyAPI](./src/LazyAPI/README.md) |
| [ChattyBridge](./src/ChattyBridge/README.md) | 0.0% | Usado para el chat entre servidores | [LazyAPI](./src/LazyAPI/README.md) |
| [ChestRestore](./src/ChestRestore/README.md) | 0.0% | Objetos infinitos en servidores de recursos |  |
| [Chireiden.TShock.Omni](https://github.com/sgkoishi/yaaiomni/blob/master/README.md) | 0.0% | Otro plugin misceláneo para TShock - la parte central |  |
| [Chireiden.TShock.Omni.Misc](https://github.com/sgkoishi/yaaiomni/blob/master/README.md) | 0.0% | Otro plugin misceláneo para TShock - la parte miscelánea | [Chireiden.TShock.Omni](https://github.com/sgkoishi/yaaiomni/blob/master/README.md) |
| [CNPCShop](./src/CNPCShop/README.md) | 0.0% | Tienda personalizada de NPC |  |
| [ConsoleSql](./src/ConsoleSql/README.md) | 0.0% | Ejecutar sentencias SQL en la consola |  |
| [ConvertWorld](./src/ConvertWorld/README.md) | 0.0% | Convertir objetos del mundo al derrotar monstruos |  |
| [CreateSpawn](./src/CreateSpawn/README.md) | 0.0% | Generación de puntos de aparición | [LazyAPI](./src/LazyAPI/README.md) |
| [CriticalHit](./src/CriticalHit/README.md) | 0.0% | Indicación de golpe crítico |  |
| [Crossplay](https://github.com/UnrealMultiple/Crossplay/blob/main/README.md) | 0.0% | Permite el juego multiplataforma |  |
| [CustomMonster](./src/CustomMonster/README.md) | 0.0% | Personalizar, modificar y generar monstruos y jefes  |  |
| [DamageRuleLoot](./src/DamageRuleLoot/README.md) | 0.0% | Determinar la bolsa de tesoro caída basada en la relación de daño y transferir el cálculo de daño |  |
| [DamageStatistic](./src/DamageStatistic/README.md) | 100.0% | Mostrar el daño causado por cada jugador después de cada pelea de jefe |  |
| [DataSync](./src/DataSync/README.md) | 0.0% | Sincronización de progreso |  |
| [DeathDrop](./src/DeathDrop/README.md) | 100.0% | Botín aleatorio y personalizado al morir un monstruo |  |
| [DisableMonsLoot](./src/DisableMonsLoot/README.md) | 11.1% | Prohibir el botín de monstruos |  |
| [DonotFuck](./src/DonotFuck/README.md) | 15.0% | Prevenir groserías | [LazyAPI](./src/LazyAPI/README.md) |
| [DTEntryBlock](./src/DTEntryBlock/README.md) | 0.0% | Prevenir la entrada a mazmorras o templos |  |
| [Dummy](./src/Dummy/README.md) | 0.0% | Servidor de Pruebas (Ficticio) Para TEST | [LazyAPI](./src/LazyAPI/README.md) [TrProtocol]() |
| [DumpTerrariaID](./src/DumpTerrariaID/README.md) | 0.0% | Volcar las ID de Terraria |  |
| [DwTP](./src/DwTP/README.md) | 0.0% | Teletransportación por posicionamiento |  |
| [Economics.Deal](./src/Economics.Deal/README.md) | 0.0% | Plugin de comercio | [EconomicsAPI](./src/EconomicsAPI/README.md) |
| [Economics.NPC](./src/Economics.NPC/README.md) | 0.0% | Recompensas personalizadas de monstruos | [EconomicsAPI](./src/EconomicsAPI/README.md) |
| [Economics.Projectile](./src/Economics.Projectile/README.md) | 0.0% | Proyectiles personalizados | [EconomicsAPI](./src/EconomicsAPI/README.md) [Economics.RPG](./src/Economics.RPG/README.md) |
| [Economics.Regain](./src/Economics.Regain/README.md) | 0.0% | Reciclaje de objetos | [EconomicsAPI](./src/EconomicsAPI/README.md) |
| [Economics.RPG](./src/Economics.RPG/README.md) | 0.0% | Plugin RPG | [EconomicsAPI](./src/EconomicsAPI/README.md) |
| [Economics.Shop](./src/Economics.Shop/README.md) | 0.0% | Plugin de tienda | [EconomicsAPI](./src/EconomicsAPI/README.md) [Economics.RPG](./src/Economics.RPG/README.md) |
| [Economics.Skill](./src/Economics.Skill/README.md) | 0.0% | Plugin de habilidades | [EconomicsAPI](./src/EconomicsAPI/README.md) [Jint]() [Economics.RPG](./src/Economics.RPG/README.md) |
| [Economics.Task](./src/Economics.Task/README.md) | 0.0% | Plugin de tareas | [EconomicsAPI](./src/EconomicsAPI/README.md) [Economics.RPG](./src/Economics.RPG/README.md) |
| [Economics.WeaponPlus](./src/Economics.WeaponPlus/README.md) | 0.0% | Mejora de armas | [EconomicsAPI](./src/EconomicsAPI/README.md) |
| [EconomicsAPI](./src/EconomicsAPI/README.md) | 0.0% | Plugin económico |  |
| [EndureBoost](./src/EndureBoost/README.md) | 0.0% | Otorga un buff específico cuando el jugador tiene una cantidad determinada de objetos |  |
| [EssentialsPlus](./src/EssentialsPlus/README.es-ES.md) | 99.2% | Comandos de gestión adicionales | [LazyAPI](./src/LazyAPI/README.md) |
| [Ezperm](./src/Ezperm/README.md) | 0.0% | Cambio por lotes de permisos | [LazyAPI](./src/LazyAPI/README.md) |
| [FishShop](https://github.com/UnrealMultiple/TShockFishShop/blob/master/README.md) | 0.0% | Tienda de peces |  |
| [GenerateMap](./src/GenerateMap/README.md) | 0.0% | Generar imágenes de mapas | [CaiLib](./src/CaiLib/README.md) |
| [GolfRewards](./src/GolfRewards/README.md) | 0.0% | Recompensas de golf |  |
| [GoodNight](./src/GoodNight/README.md) | 0.0% | Toque de queda |  |
| [HardPlayerDrop](./src/HardPlayerDrop/README.md) | 0.0% | Los jugadores en modo Hardcore sueltan corazones de vida al morir |  |
| [HelpPlus](./src/HelpPlus/README.md) | 0.0% | Corrige y mejora el comando de ayuda |  |
| [History](./src/History/README.md) | 0.0% | Registra un historial en formato de tabla |  |
| [HouseRegion](./src/HouseRegion/README.md) | 0.0% | Plugin de reclamación de tierras | [LazyAPI](./src/LazyAPI/README.md) |
| [Invincibility](./src/Invincibility/README.md) | 0.0% | Invencibilidad limitada en el tiempo |  |
| [ItemBox](./src/ItemBox/README.md) | 0.0% | Inventario fuera de línea |  |
| [ItemDecoration](./src/ItemDecoration/README.es-ES.md) | 100.0% | Muestra el spryte y texto de info y damage del item seleccionado | [LazyAPI](./src/LazyAPI/README.md) |
| [ItemPreserver](./src/ItemPreserver/README.md) | 50.0% | Conserva ítems específicos de la consumición |  |
| [JourneyUnlock](./src/JourneyUnlock/README.md) | 6.3% | Desbloquea ítems del modo Journey |  |
| [Lagrange.XocMat.Adapter](./src/Lagrange.XocMat.Adapter/README.md) | 100.0% | Plugin adaptador para el bot Lagrange.XocMat | [SixLabors.ImageSharp]() |
| [LazyAPI](./src/LazyAPI/README.md) | 0.0% | Biblioteca base para plugins | [linq2db]() |
| [LifemaxExtra](./src/LifemaxExtra/README.md) | 0.0% | Comer más frutas/cristales de vida | [LazyAPI](./src/LazyAPI/README.md) |
| [ListPlugins](./src/ListPlugins/README.md) | 16.7% | Lista los plugins instalados |  |
| [MapTp](./src/MapTp/README.md) | 100.0% | Teletransportarse con doble clic en el mapa |  |
| [MiniGamesAPI](./src/MiniGamesAPI/README.md) | 0.0% | API para el mini-juego de pasta de frijol |  |
| [ModifyWeapons](./src/ModifyWeapons/README.md) | 0.0% | Deje que los jugadores realicen dos Sprint | [LazyAPI](./src/LazyAPI/README.md) |
| [MonsterRegen](./src/MonsterRegen/README.md) | 0.0% | Regeneración de progreso de monstruos |  |
| [MusicPlayer](./src/MusicPlayer/README.md) | 0.0% | Reproductor de música simple |  |
| [Noagent](./src/Noagent/README.md) | 0.0% | Prohíbe que las IPs de proxy ingresen al servidor |  |
| [NormalDropsBags](./src/NormalDropsBags/README.md) | 0.0% | Suelta bolsas de tesoros en dificultad normal |  |
| [NoteWall](./src/NoteWall/README.md) | 0.0% | Los jugadores pueden dejar y ver notas aquí. | [LazyAPI](./src/LazyAPI/README.md) [linq2db]() |
| [OnlineGiftPackage](./src/OnlineGiftPackage/README.md) | 0.0% | Paquete de regalos en línea |  |
| [PacketsStop](./src/PacketsStop/README.md) | 0.0% | Interceptación de paquetes |  |
| [PermaBuff](./src/PermaBuff/README.md) | 0.0% | Buff permanente |  |
| [PerPlayerLoot](./src/PerPlayerLoot/README.md) | 0.0% | Cofre separado para el botín del jugador |  |
| [PersonalPermission](./src/PersonalPermission/README.md) | 0.0% | Establece permisos individualmente para los jugadores |  |
| [Platform](./src/Platform/README.md) | 0.0% | Determina el dispositivo del jugador |  |
| [PlayerManager](https://github.com/UnrealMultiple/TShockPlayerManager/blob/master/README.md) | 0.0% | Administrador de jugadores de Hufang |  |
| [PlayerRandomSwapper](./src/PlayerRandomSwapper/README.md) | 0.0% | Intercambio de posiciones aleatorio de jugadores | [LazyAPI](./src/LazyAPI/README.md) |
| [PlayerSpeed](./src/PlayerSpeed/README.md) | 0.0% | Interceptación de paquetes | [LazyAPI](./src/LazyAPI/README.md) |
| [ProgressBag](./src/ProgressBag/README.md) | 0.0% | Paquete de progreso | [LazyAPI](./src/LazyAPI/README.md) |
| [ProgressControls](./src/ProgressControls/README.md) | 0.0% | Planificador (Automatiza el control del servidor) |  |
| [ProgressRestrict](./src/ProgressRestrict/README.md) | 0.0% | Detección de super progreso | [DataSync](./src/DataSync/README.md) |
| [ProxyProtocolSocket](./src/ProxyProtocolSocket/README.md) | 0.0% | Acepta conexiones de protocolo proxy |  |
| [PvPer](./src/PvPer/README.md) | 0.0% | Sistema de duelos |  |
| [RainbowChat](./src/RainbowChat/README.md) | 0.0% | Colores aleatorios en el chat |  |
| [RandomBroadcast](./src/RandomBroadcast/README.md) | 0.0% | Transmisión aleatoria |  |
| [RandRespawn](./src/RandRespawn/README.md) | 0.0% | Punto de aparición aleatorio |  |
| [RealTime](./src/RealTime/README.md) | 0.0% | Sincroniza la hora del servidor con la hora real |  |
| [RebirthCoin](./src/RebirthCoin/README.md) | 0.0% | Consume ítems designados para revivir al jugador |  |
| [RecipesBrowser](./src/RecipesBrowser/README.md) | 0.0% | Mesa de trabajo |  |
| [ReFishTask](./src/ReFishTask/README.md) | 0.0% | Refresca automáticamente las tareas del pescador |  |
| [RegionView](./src/RegionView/README.md) | 0.0% | Muestra los límites de las áreas |  |
| [Respawn](./src/Respawn/README.md) | 0.0% | Reaparece en el lugar de la muerte |  |
| [RestInventory](./src/RestInventory/README.md) | 0.0% | Proporciona una interfaz de consulta REST para la mochila |  |
| [ReverseWorld](./src/ReverseWorld/README.md) | 0.0% | Complemento de Inversión del Mundo y Colocación de Minas Terrestres |  |
| [RolesModifying](./src/RolesModifying/README.md) | 0.0% | Modificar mochila del jugador |  |
| [Sandstorm](./src/Sandstorm/README.md) | 0.0% | Alterna la tormenta de arena |  |
| [ServerTools](./src/ServerTools/README.md) | 0.0% | Herramientas de administración del servidor | [LazyAPI](./src/LazyAPI/README.md) [linq2db]() |
| [SessionSentinel](./src/SessionSentinel/README.md) | 0.0% | Maneja jugadores que no envían paquetes de datos por mucho tiempo |  |
| [ShortCommand](./src/ShortCommand/README.md) | 0.0% | Comando corto |  |
| [ShowArmors](./src/ShowArmors/README.md) | 0.0% | Muestra la barra de equipo |  |
| [SignInSign](./src/SignInSign/README.md) | 0.0% | Plugin de inicio de sesión con cartel |  |
| [SimultaneousUseFix](./src/SimultaneousUseFix/README.md) | 0.0% | Resuelve problemas como el martillo doble atascado y la metralleta de estrellas | [Chireiden.TShock.Omni](https://github.com/sgkoishi/yaaiomni/blob/master/README.md) |
| [SmartRegions](./src/SmartRegions/README.md) | 0.0% | Regiones inteligentes |  |
| [SpawnInfra](./src/SpawnInfra/README.md) | 0.0% | Genera infraestructura básica |  |
| [SpclPerm](./src/SpclPerm/README.md) | 0.0% | Privilegios del propietario del servidor |  |
| [StatusTextManager](./src/StatusTextManager/README.md) | 100.0% | Plugin para gestionar el texto de estado en PC |  |
| [SurfaceBlock](./src/SurfaceBlock/README.md) | 0.0% | Prohibir proyectiles en la superficie  | [LazyAPI](./src/LazyAPI/README.md) |
| [SurvivalCrisis](./src/SurvivalCrisis/README.md) | 0.0% | 'Among Us' como un juego'' |  |
| [SwitchCommands](./src/SwitchCommands/README.md) | 0.0% | Ejecuta comandos en regiones |  |
| [TeleportRequest](./src/TeleportRequest/README.md) | 0.0% | Solicitud de teletransporte |  |
| [TimeRate](./src/TimeRate/README.md) | 0.0% | Modifica la aceleración del tiempo usando comandos, y soporta el sueño de los jugadores para activar eventos |  |
| [TimerKeeper](./src/TimerKeeper/README.md) | 0.0% | Guarda el estado del temporizador |  |
| [TownNPCHomes](./src/TownNPCHomes/README.md) | 0.0% | Casa rápida de NPC |  |
| [TShockConfigMultiLang](./src/TShockConfigMultiLang/README.md) | 0.0% | Localización del idioma de configuración de TShock | [LazyAPI](./src/LazyAPI/README.md) |
| [UnseenInventory](./src/UnseenInventory/README.md) | 0.0% | Permite que el servidor genere ítems "inobtenibles" |  |
| [VBY.Common](https://github.com/UnrealMultiple/MyPlugin/blob/master/docs/VBY.Common.md) | 0.0% | Biblioteca base para plugins VBY |  |
| [VBY.GameContentModify](https://github.com/UnrealMultiple/MyPlugin/blob/master/docs/VBY.GameContentModify.md) | 0.0% | Modificaciones personalizables para cierto contenido del juego (super) | [VBY.Common](https://github.com/UnrealMultiple/MyPlugin/blob/master/docs/VBY.Common.md) |
| [VBY.OtherCommand](https://github.com/UnrealMultiple/MyPlugin/blob/master/docs/VBY.OtherCommand.md) | 0.0% | Proveer algunos otros comandos auxiliares | [VBY.Common](https://github.com/UnrealMultiple/MyPlugin/blob/master/docs/VBY.Common.md) |
| [VBY.PluginLoader](https://github.com/UnrealMultiple/MyPlugin/blob/master/docs/VBY.PluginLoader.md) | 0.0% | Un cargador de plugins que permite la recarga en caliente |  |
| [VBY.PluginLoaderAutoReload](https://github.com/UnrealMultiple/MyPlugin/blob/master/docs/VBY.PluginLoaderAutoReload.md) | 0.0% | VBY.PluginLoader的扩展, 自动热重载插件 | [VBY.PluginLoader](https://github.com/UnrealMultiple/MyPlugin/blob/master/docs/VBY.PluginLoader.md) |
| [VeinMiner](./src/VeinMiner/README.md) | 0.0% | Minado en cadena |  |
| [VotePlus](./src/VotePlus/README.md) | 96.1% | Votación multifuncional |  |
| [WeaponPlus](./src/WeaponPlus/README.md) | 100.0% | Versión de monedas para mejorar armas |  |
| [WikiLangPackLoader](./src/WikiLangPackLoader/README.md) | 100.0% | Cargue el paquete de idioma wiki para el servidor. |  |
| [WorldModify](https://github.com/UnrealMultiple/TShockWorldModify/blob/master/README.md) | 0.0% | Editor del mundo, permite modificar la mayoría de los parámetros del mundo |  |
| [ZHIPlayerManager](./src/ZHIPlayerManager/README.md) | 62.9% | Plugin de gestión de jugadores de Zhi |  |

</Details>

## Traducción

- Si deseas participar en el trabajo de traducción, no dudes en visitar nuestro enlace de [Crowdin](https://es.crowdin.com/project/tshock-chinese-plugin)

## Links

- [TShock Plugin Development Documentation](https://github.com/ACaiCat/TShockPluginDocument)
- [Tshock Comprehensive Navigation](https://github.com/UnrealMultiple/Tshock-nav)
