# pvper 决斗系统

- 作者: Soofa、羽学  
- 出处: [github](https://github.com/Soof4/PvPer/)  
+ 这是一个Tshock服务器插件主要用于：  
- 实现了玩家间的PvP战斗功能，插件使用SQLite数据库存储决斗数据，  
- 通过事件钩子监听游戏事件，对玩家行为进行限制与管理，确保决斗规则得到遵循。  
- 同时，插件支持配置文件加载与重载。  
- 注意：玩家如果脱离竞技范围则会被直接杀死判输。  

## 指令

| 语法                 |     权限      |              说明               |
|--------------------|:-----------:|:-----------------------------:|
| /pvp add 玩家名       |  pvper.use  |           邀请玩家参加决斗            |
| /pvp yes           |  pvper.use  |             同意决斗              |
| /pvp no            |  pvper.use  |             拒绝决斗              |
| /pvp list          |  pvper.use  |              排行榜              |
| /pvp data          |  pvper.use  |             战绩查询              |
| /pvp.WL            |  pvper.use  |            查封禁武器表             |
| /pvp.BL            |  pvper.use  |           查封禁BUFF表            |
| /pvp set 1 2 3 4   |  pvper.use  | 将当前位置同步到坐标 1/2是玩家位置 3/4是竞技场边界 |
| /pvp reset         | pvper.admin |           重置玩家的数据库表           |
| /pvp.BW add <武器名>  | pvper.admin |         封禁PVP状态下的指定武器         |
| /pvp.BB add <增益ID> | pvper.admin |         封禁PVP状态下的指定增益         |


## 配置
> 配置文件位置：tshock/决斗系统.json
```json5
{
  "插件权限名": "pvper.use / pvper.admin",
  "竞技场边界说明": "/pvp set 3 4 要比玩家传送坐标高或低3格设置",
  "竞技场边界说明2": "拉取范围：会从玩家冲出竞技场方向,拉回到竞技场中心的指定反向位置（当为负数则是正向位置）,关闭杀死玩家选项后默认开启扣血",
  "启用检查": true,
  "是否检查第7个饰品栏": false,
  "拉回竞技场": true,
  "拉取范围": -20,
  "离开竞技场杀死玩家": false,
  "离场扣血": 20,
  "邀请者传送坐标.X": 0,
  "邀请者传送坐标.Y": 0,
  "受邀者传送坐标.X": 0,
  "受邀者传送坐标.Y": 0,
  "竞技场左上角坐标.X": 0,
  "竞技场左上角坐标.Y": 0,
  "竞技场右下角坐标.X": 0,
  "竞技场右下角坐标.Y": 0,
  "禁武器表": [],
  "禁BUFF表": []
}
```

## 更新日志

### v1.1.3
- 完善卸载函数（也许）
### v1.1.2
- 优化了/pvp help 翻页
- 加入了新指令与武器/BUFF的相关检测机制
- 配置文件更新了【启用检查】、【是否检查第7个饰品栏】、【禁武器表】、【禁BUFF表】（这2个表会自动根据指令写入）

### v1.1.1
- 配置文件中加入了【拉取范围】、是否【拉回竞技场】配置项  
- 拉取范围为0时，传送冲出竞技场的玩家到竞技场中心点  
- 拉取范围为负数时，拉取玩家到中心点与对应的玩家冲出相对方向  
- 拉取范围为正数时，拉取玩家到中心点与对应的玩家冲出相反方向  

### v1.1.0
- 将[决斗重置]命令放进了/pvp help
- 加入了死亡嘲讽与连胜统计播报
- 配置文件加入了离场扣血(关闭死亡惩罚时默认开启)

### v1.0.3
- 新增了子命令可快速设置玩家与竞技场的界限（自动写入Config并保存更新）
- 配置文件加了个【离开竞技场杀死玩家】的开关选项并进行了汉化
- 修复了离开竞技场判定死亡的设定。

### v1.0.2
- 羽学汉化并修改了所有指令与其回馈信息，  
- 并加入了个新指令权限用于重置玩家数据表


## 反馈
- 优先发issued -> 共同维护的插件库：https://github.com/UnrealMultiple/TShockPlugin
- 次优先：TShock官方群：816771079
- 大概率看不到但是也可以：国内社区trhub.cn ，bbstr.net , tr.monika.love
