# ServerTools 服务器工具箱

- **作者**: 少司命
- **出处**: 无
- 该插件提供更多指令与功能方便管理服务器
- 该插件会生成一个ReadPlayers文件夹，只有在使用`/readplayer`指令时会用到!

## 指令

| 语法                                                                                                                  |           权限           |         说明          |
|---------------------------------------------------------------------------------------------------------------------|:----------------------:|:-------------------:|
| /clp [范围]                                                                                                           |      tshock.clear      |    清理弹幕但不清理玩家召唤物    |
| /退出 或 /toolexit                                                                                                     | servertool.query.exit  |       手机端玩家自踢       |
| /查花苞 或 /scp                                                                                                         | servertool.query.wall  | 查找地图上的花苞并添加到 Warp 里 |
| /移除花苞 或 /rcp                                                                                                        | servertool.query.wall  |    移除调 Warp 里的花苞    |
| /自踢 或 /selfkick                                                                                                     |  servertool.user.kick  |      将自己踢出服务器       |
| /自杀 或 /selfkill                                                                                                     |  servertool.user.kill  |        杀死自己         |
| /ghost                                                                                                              | servertool.user.ghost  |    切换到幽灵状态再次使用复原    |
| /旅途难度 [难度]`master` `journey` `normal` `expert` 或 /journeydiff [difficulty mode]`master` `journey` `normal` `expert` | servertool.set.journey |      设置旅途模式难度       |
| /rank <online|dead> 或 /排行 <在线|死亡>                                                                                 | servertool.user.rank |      查询玩家排行       |
| /oc [玩家名称] [指令]                                                                                                    |  servertool.user.cmd  |      为指定玩家执行命令        |
| /readplayer                   | servertool.readplayer.use | 读取并保存文件夹下所有存档到数据库				|
| /readplayer [文件名]      | servertool.readplayer.use | 读取并保存文件夹下指定文存档到数据库            |
| /readplayer [文件名] [角色名]   | servertool.readplayer.use | 读取存档到指定角色下             |

## REST API

| 路径              |    说明    |
|-----------------|:--------:|
| /deathrank      | 查询死亡排行数据 |
| /onlineDuration | 查询在线排行数据 |

## 配置
> 配置文件位置：tshock/ServerTools.json

```json5
{
  "死亡延续": true,
  "限制哨兵数量": 20,
  "限制召唤物数量": 11,
  "仅允许软核进入": false,
  "是否设置世界模式": true,
  "世界模式": 2,
  "限制发言长度": 50,
  "设置旅途模式难度": false,
  "旅途模式难度": "master",
  "阻止未注册进入": false,
  "禁止怪物捡钱": true,
  "清理掉落物": false,
  "死亡倒计时": false,
  "阻止死亡角色进入": true,
  "禁止双箱": true,
  "禁止双饰品": true,
  "禁止肉前第七格饰品": true,
  "死亡倒计时格式": "你还有{0}秒复活!",
  "未注册阻止语句": "未注册不能进入服务器",
  "未注册启动服务器执行命令": [],
  "开启NPC保护": false,
  "NPC保护表": [
    17,
    18,
    19,
    20,
    38,
    105,
    106,
    107,
    108,
    160,
    123,
    124,
    142,
    207,
    208,
    227,
    228,
    229,
    353,
    354,
    376,
    441,
    453,
    550,
    579,
    588,
    589,
    633,
    663,
    678,
    679,
    680,
    681,
    682,
    683,
    684,
    685,
    686,
    687,
    375,
    442,
    443,
    539,
    444,
    445,
    446,
    447,
    448,
    605,
    627,
    601,
    613
  ],
  "禁止多鱼线": true,
  "浮漂列表": [
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    381,
    382,
    760,
    775,
    986,
    987,
    988,
    989,
    990,
    991,
    992,
    993
  ]
}
```

| 字段             |       类型        |               说明               |                 可能的值                 |
|----------------|:---------------:|:------------------------------:|:------------------------------------:|
| `死亡延续`         |     `bool`      | 当玩家以死亡状态退出服务器，再次进入服务器需要等待死亡结束。 |                  空                   |
| `限制哨兵数量`       |     `int32`     |          限制玩家可召唤哨兵数量           |                  空                   |
| `限制召唤物数量`      |     `int32`     |          限制玩家可召唤召唤物数量          |                  空                   |
| `仅允许软核进入`      |     `bool`      |                                |                  空                   |
| `是否设置世界模式`     |     `bool`      |        如果为 true 设置世界模式         |                  空                   |
| `设置世界模式`       |     `int32`     |               难度               |     `0`为旅途 `1`为普通 `2`为专家 `3`为大师      |
| `限制发言长度`       |     `int32`     |             发言长度限制             |                  空                   |
| `设置旅途模式难度`     |     `bool`      |         为 true 时设置旅途难度         |                  空                   |
| `旅途模式难度`       |    `string`     |               难度               | `master` `journey` `normal` `expert` |
| `阻止未注册进入 `     |     `bool`      |          阻止未注册玩家进入服务器          |                  空                   |
| `禁止怪物捡钱 `      |     `bool`      |          玩家死亡后怪物无法捡钱           |                  空                   |
| `清理掉落物`        |     `bool`      |           清理玩家死亡后掉落物           |                  空                   |
| `阻止死亡角色进入`     |     `bool`      |  禁止玩家以死亡状态进入服务器，需玩家进入单机模式结束死亡  |                  空                   |
| `死亡倒计时`        |     `bool`      |           是否开启死亡倒计时            |                  空                   |
| `禁止双箱`         |     `bool`      |           禁止同时打开两个箱子           |                  空                   |
| `禁止双饰品`        |     `bool`      |          禁止重复装备相同的饰品           |                  空                   |
| `禁止肉前第七格饰品`    |     `bool`      |          禁止肉前就有第七个饰品栏          |                  空                   |
| `死亡倒计时格式`      |    `string`     |            死亡倒计时格式             |              `{0}`剩下时间               |
| `未注册阻止语句`      |    `string`     |           阻止未注册玩家提示语           |                  空                   |
| `未注册启动服务器执行命令` | `array<string>` |       当服务器启动且没有注册玩家时执行命令       |                  空                   |
| `开启NPC保护 `     |     `bool`      |            开启NPC保护             |                  空                   |
| `NPC保护表`       |  `array<int>`   |             NPC保护表             |                  空                   |
| `禁止多鱼线 `       |     `bool`      |          阻止玩家卡多鱼线 Bug          |                  空                   |
| `浮漂列表`         |  `array<int>`   |           检测多鱼线浮漂列表            |                  空                   |

## 更新日志

### v1.2.0.0
- 添加命令/readplayer

### v1.1.8.7
- 去掉 "请等待死亡结束，还有{respawn.TotalSeconds}秒结束！" 的小数

### v1.1.8.6
- 把英文命令提到前面

### v1.1.8.5
- 修复配置项无法热重载的问题

### v1.1.7.9
- 修复hook报错

### v1.1.7.8
- 也许根本不需要判Main.projectile[e.Index].minion，以及非SSC情况下检测到多饰品不尝试为玩家摘下

### v1.1.7.7
- 修复召唤物和哨兵检测问题，完成i18n英文

### v1.1.7.6
- 修正默认值和文档，i18n预备

### v1.1.7.5
- 添加配置限制召唤物数量

### v1.1.7.4
- 完善卸载函数

### v1.1.7.0
- 修复手游恶魔之心格子不正确问题
- 使用_timer字段加快清除速度

### v1.1.6.0
- 添加NPC保护
- 添加禁止肉前第七格饰品栏

### v1.1.5.0
- 给禁双饰品加入清理物品方法，避免重复刷控制台。
- 只检测Armor前10个格子

### v1.1.4.0
- 只检查当前装备页与饰品栏
- 给禁双饰品加免检权限：servertool.armor.white
- 修复空饰品时的误判

### v1.1.3.0
- 配置项加了【禁双饰品】
- 为兼容旧版添加2个别名命令
- 给/查花苞加了个字母命令：/scp
- 给/移除花苞加了个字母命令：/rcp

### v1.1.2.0
- 给TShock自带的/ai指令 加入了查询指定玩家的账户ID

### v1.1.1.0
- 修复禁止怪物捡钱
- 移除了禁止快速放入箱子

### v1.1.0.0
- 添加双箱限制

### v1.0.0.4
- 修复使用Rest时无法使用ban指令的问题

### v1.0.0.3
- 修复死亡排行添加数据库报错
- 修复死亡倒计时


## 反馈
- 优先发issued -> 共同维护的插件库：https://github.com/UnrealMultiple/TShockPlugin
- 次优先：TShock官方群：816771079
- 大概率看不到但是也可以：国内社区trhub.cn ，bbstr.net , tr.monika.love